//
//  main.m
//  Boxcel Helper
//

#import <AppKit/AppKit.h>

int main(int argc, const char * argv[]) {
    @autoreleasepool {
        
        //NSLog(@"argc: %d", argc);
        
        int targetWidth, targetHeight;
        NSString *imagePath, *dataPath;
        
        if (argc == 5) {
            targetWidth = atof(argv[1]);
            targetHeight = atof(argv[2]);
            imagePath = [NSString stringWithCString:argv[3] encoding:NSUTF8StringEncoding];
            dataPath = [NSString stringWithCString:argv[4] encoding:NSUTF8StringEncoding];
        } else {
            targetWidth = 12;
            targetHeight = 12;
            imagePath = @"/Users/tg/Desktop/test.png";
            dataPath = @"/tmp/boxcelData.data";
        }
        
        
        NSLog(@"width: %d, height: %d, image: %@, data: %@", targetWidth, targetHeight, imagePath, dataPath);
        
        NSImage * image = [[NSImage alloc] initWithContentsOfFile:imagePath];
        
        if (image != nil) {
            NSSize targetSize = NSMakeSize( targetWidth, targetHeight );
            
            NSImage * targetImage = [[NSImage alloc] initWithSize:targetSize];
            
            [targetImage lockFocus];
            [[NSGraphicsContext currentContext] setImageInterpolation:NSImageInterpolationHigh];
            [image drawInRect:CGRectMake(0, 0, targetSize.width, targetSize.height) fromRect:NSZeroRect operation:NSCompositeCopy fraction:1.0];
            [targetImage unlockFocus];
            
            NSSize size = [targetImage size];
            uint32_t width = (uint32_t) size.width, height = (uint32_t) size.height, components = 4;
            uint8_t *pixels = (uint8_t *) malloc(size.width * size.height * components);
            if (pixels) {
                CGColorSpaceRef colorSpace = CGColorSpaceCreateDeviceRGB();
                CGContextRef bitmapContext = CGBitmapContextCreate(pixels, width, height, 8, components * width, colorSpace, kCGImageAlphaPremultipliedLast);
                NSRect rect = NSMakeRect(0, 0, width, height);
                NSGraphicsContext *graphicsContext = (NSGraphicsContext *) [[NSGraphicsContext currentContext] graphicsPort];
                CGImageRef cgImage = [targetImage CGImageForProposedRect:&rect context:graphicsContext hints:nil];
                CGContextDrawImage(bitmapContext, NSRectToCGRect(rect), cgImage);
                CGContextRelease(bitmapContext);
                CGColorSpaceRelease(colorSpace);
                
                NSMutableData * data = [[NSMutableData alloc] init];
                
                int size[] = { targetWidth, targetHeight };
                [data appendBytes:&size length:sizeof(int) * 2 ];
                
                for (int i = 0;i < targetWidth;i++) {
                    for (int j = 0;j < targetHeight;j++) {
                        uint8_t r = pixels[ (i * 4) + (j * 4 * width)];
                        uint8_t g = pixels[ (i * 4) + (j * 4 * width) + 1];
                        uint8_t b = pixels[ (i * 4) + (j * 4 * width) + 2];
                        uint8_t a = pixels[ (i * 4) + (j * 4 * width) + 3];
                        
                        float col[] = { (float)r / 255, (float)g / 255, (float)b / 255, (float)a / 255 };
                        //NSLog(@"%.2f, %.2f, %.2f, %.2f", col[0], col[1], col[2], col[3]);
                        [data appendBytes:&col length:sizeof(float) * 4];
                    }
                }
                
                //NSLog(@"%@", [data description]);
                
                [data writeToFile:dataPath atomically:YES];
                //NSLog(@"save data to %@", dataPath);
                
                free(pixels);
            }
            
        }
        
    }
    return 0;
}
